// hipshot's water shader for alpha blending to zero
textures/ct_testWaterBlend/water_01
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	{
		map textures/ct_testWaterBlend/hipshot_water.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 .15 0 .015	
	}	
	{
		map textures/ct_testWaterBlend/hipshot_water2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 -.15 0 -.015				
	}	
}

// hipshot's water shader for alpha blending to zero
// with a solid color layer
textures/ct_testWaterBlend/water_02
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	{
		map textures/ct_testWaterBlend/hipshot_water.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 .15 0 .015	
	}	
	{
		map textures/ct_testWaterBlend/hipshot_water2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 -.15 0 -.015				
	}	
	{
		map textures/ct_testWaterBlend/waterColor_02_50.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}		
}

// hipshot's water shader for alpha blending to zero
// with a solid color layer and an envmap
textures/ct_testWaterBlend/water_03
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	{
		map textures/ct_testWaterBlend/hipshot_water.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 .15 0 .015	
	}	
	{
		map textures/ct_testWaterBlend/hipshot_water2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 -.15 0 -.015				
	}	
	{
		map textures/ct_testWaterBlend/waterColor_02_50.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex
	}		
	{
		map textures/ct_testWaterBlend/waterFX_01.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 0.5 0.5
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap
textures/ct_testWaterBlend/water_04
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	{
		map textures/ct_testWaterBlend/hipshot_water.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 .15 0 .015	
	}	
	{
		map textures/ct_testWaterBlend/hipshot_water2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 -.15 0 -.015				
	}	
	{
		map textures/ct_testWaterBlend/waterFX_01.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 0.5 0.5
	}	
}




// hipshot's water shader for alpha blending to zero
// with an envmap
// with tesselation
textures/ct_testWaterBlend/water_tess_01
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	tessSize 32 
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
		//tcmod scroll 0.02 0.01
		//tcMod turb 0 .015 0 .01	
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap
// without tesselation
textures/ct_testWaterBlend/water_notess_01
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod scroll
// with tesselation
textures/ct_testWaterBlend/water_tess_01-scroll
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	tessSize 32
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
		tcmod scroll 0.02 0.01
		//tcMod turb 0 .015 0 .01	
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod turb
// for use on tesselated mesh
textures/ct_testWaterBlend/water_tess_01-turb
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	deformVertexes wave 1000 sin -2 2 0 0.2 
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
		tcMod turb 0 .025 0 .15	
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod turb
// for use on tesselated mesh
textures/ct_testWaterBlend/water_tess_01-turb-alpha
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
	deformVertexes wave 1000 sin -2 2 0 0.2 
	{
		map textures/ct_testWaterBlend/hipshot_water.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 .15 0 .015	
	}	
	{
		map textures/ct_testWaterBlend/hipshot_water2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		alphaGen vertex	
		tcmod scale 1 1			
		tcMod turb 0 -.15 0 -.015				
	}	
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
		tcMod turb 0 .025 0 .15	
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod scroll
// for use on tesselated mesh with deformVertex as suggested by quBit
textures/ct_testWaterBlend/water_tess_02-deform-move-wave
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	cull none
    deformVertexes wave 1000 sin -2 3 0 0.2 
    deformVertexes move 32 0 0 sin 0 1 0.0 0.03
    deformVertexes move 0 32 0 sin 0 1 0.25 0.03
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scale 2 2
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod scroll
// with tesselation and deformVertex
textures/ct_testWaterBlend/water_tess_03-static-deform
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	tessSize 16
    deformVertexes move 1 0 0 sin 0 5 0.0 0.02
    deformVertexes move 0 1 0 sin 0 5 0.25 0.02
    deformVertexes wave 32 sin 0 2 0 0.15
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scroll 0.005 0.001
		tcmod scale 2 2
		tcMod turb 0 .015 0 .01	
	}	
}

// hipshot's water shader for alpha blending to zero
// with an envmap with tcmod scroll
// with tesselation and deformVertex
textures/ct_testWaterBlend/water_tess_03b-deform-normal
{
	qer_editorimage textures/ct_testWaterBlend/hipshot_water.tga
	q3map_globaltexture
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm nolightmap
	nopicmip
	noMipMaps
	tessSize 16
    deformVertexes normal 4 0.015
	{
		map textures/ct_testWaterBlend/waterFX_02-green.tga
		rgbGen identity
		tcGen environment 
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen vertex	
		tcmod scroll 0.005 0.001
		tcmod scale 0.5 0.5
		tcMod turb 0 .15 0 .015	
	}	
}







// you'll shoot your eye out fog (Lunaran & KungFuSquirrel)
textures/ct_testWaterBlend/levelfog
{
	qer_editorimage textures/ct_testWaterBlend/sky/sky_rt.tga
	
	// the fog brush scatters bounce light in q3map2 using the editorimage as lightimage unless this is set :(
	q3map_bounceScale 0.0
	
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	fogparms ( 0.4 0.6 0.8 ) 25600
}

// Industrial sky (Hipshot)
textures/ct_testWaterBlend/sky
{
	q3map_lightmapFilterRadius 0 32
	q3map_sunExt 207 221 230 2000 80 60 2 32
	qer_editorimage textures/ct_testWaterBlend/sky/sky_dn.tga
	q3map_skyLight 600 6
	q3map_noFog
	q3map_globalTexture
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	skyparms textures/ct_testWaterBlend/sky/sky - -
	nopicmip
}

// water fog (Hipshot)
textures/ct_testWaterBlend/fog_light
{
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	fogparms ( .125 .15 .15 ) 200
}

textures/ct_testWaterBlend/fog_shallowWater
{
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm	nolightmap
	fogparms ( .125 .15 .15 ) 32
}