int[][] cubes = {
	{1,5,3,4}, //top
	{2,5,0,4}, //front
	{3,5,1,4}, //bottom
	{0,5,2,4}, //back
	{1,0,3,2}, //left
	{1,2,3,0}, //left
};

Vec3 rotateX(Vec3 v, float a)
{
	a *= 1.57079633;
	return Vec3(
		v.x,
		v.y*cos(a)-v.z*sin(a),
		v.y*sin(a)+v.z*cos(a)
	);
}

Vec3 rotateY(Vec3 v, float a)
{
	a *= 1.57079633;
	return Vec3(
		v.x*cos(a)+v.z*sin(a),
		v.y,
		-v.x*sin(a)+v.z*cos(a)
	);
}

Vec3 rotateZ(Vec3 v, float a)
{
	a *= 1.57079633;
	return Vec3(
		cos(a)*v.x - sin(a)*v.y,
		sin(a)*v.x + cos(a)*v.y,
		v.z
	);
}

void MAP_PreThink()
{
	for ( int i = 0; i < numEntities; i++ )
	{
		Entity@ ent = @G_GetEntity(i);
		if ( @ent != null )
		{
			if ( ent.origin.z < 512 )
			{
				int currCube = (-ent.origin.y+2560)/5120;
				int side = -1;
				Vec3 origin = ent.origin;
				origin.y += currCube*5120;
				if ( origin.x > 512 )
					side = 0;
				if ( origin.y < -512 )
					side = 1;
				if ( origin.x < -512 )
					side = 2;
				if ( origin.y > 512 )
					side = 3;

				if ( side >= 0 && (currCube >= 0 && currCube < 6) )
				{
					int newCube = cubes[currCube][side];
					int newside;
					for ( newside = 0; newside < 4; newside++ )
					{
						if ( cubes[newCube][newside] == currCube )
							break;
					}

					int rotation = side - newside;

					Vec3 velocity = ent.velocity;
					Vec3 angles = ent.angles;
					Vec3 anglex, bla;
					angles.angleVectors(anglex,bla,bla);

					if ( side == 0 )
					{
						origin = rotateY(origin, -1);
						velocity = rotateY(velocity, -1);
						anglex = rotateY(anglex, -1);
					}
					if ( side == 1 )
					{
						origin = rotateX(origin, -1);
						velocity = rotateX(velocity, -1);
						anglex = rotateX(anglex, -1);
					}
					if ( side == 2 )
					{
						origin = rotateY(origin, 1);
						velocity = rotateY(velocity, 1);
						anglex = rotateY(anglex, 1);
					}
					if ( side == 3 )
					{
						origin = rotateX(origin, 1);
						velocity = rotateX(velocity, 1);
						anglex = rotateX(anglex, 1);
					}
					origin = rotateZ(origin, rotation-2);
					velocity = rotateZ(velocity, rotation-2);
					anglex = rotateZ(anglex, rotation-2);
					origin.y -= newCube*5120;
					if ( origin.z + 40 >= 704 )
						origin.z = 704-40;

					ent.origin = origin;
					ent.velocity = velocity;
					ent.angles = anglex.toAngles();
				}
			}
		}
	}
}