void MAP_Init()
{
	for ( int j = 0; j < numEntities; j++ )
	{
		cEntity@ ent = @G_GetEntity(j);
		if ( ent.classname == "trigger_gravity" )
		{
			cEntity@ trigger = @G_SpawnEntity("trigger_gravity_new");
			trigger.origin = ent.origin;
			Vec3 mins, maxs;
			ent.getSize(mins,maxs);
			trigger.setSize(mins,maxs);
			trigger.solid = SOLID_TRIGGER;
			trigger.wait = ent.wait;
			@trigger.touch = trigger_gravity_touch;
			ent.unlinkEntity();
			ent.freeEntity();
			trigger.linkEntity();
		}
	}
}

void trigger_gravity_touch(cEntity @ent, cEntity @other, const Vec3 planeNormal, int surfFlags)
{
	if ( @other.groundEntity != null && ent.wait <= 0 )
	{
		Vec3 orig = other.origin;
		orig.z += 1;
		other.origin = orig;
		@other.groundEntity = null;
	}

	Vec3 vel = other.velocity;
	vel.z += (850*(1-ent.wait))*(float(frameTime)/1000);
	other.velocity = vel;
}